<?php get_header(); ?>
  <header id="section-home" data-scroll-index="0" class="header slider-fade">
        <div class="owl-carousel owl-theme">
          <!--  <The opacity on the image is made with "data-overlay-dark="number". You can change it using the numbers 0-9. -->
                 <div class="text-left item bg-img" data-overlay-dark="4" data-background="<?php echo get_template_directory_uri(); ?>/img/architect.webp">
                     <div class="v-middle caption">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <h6 style="text-transform: uppercase; font-weight: 500;">welcome to cqm</h6>
                                    <h1>Your Trusted Partner in<br><span style="color: rgb(211, 7, 31);">Construction Success</span> </h1>
                                    <a href="#0" class="button-1 mt-15">Learn More <span class="ti-arrow-right"></span></a>
                                </div>
                            </div> 
                        </div>
                    </div>
                 </div>
                 <div class="text-left item bg-img" data-overlay-dark="4" data-background="<?php echo get_template_directory_uri(); ?>/img/architect.webp">
                     <div class="v-middle caption">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <h6 style="text-transform: uppercase;">welcome to cqm</h6>
                                    <h1>Your Trusted Partner in<br><span style="color: rgb(211, 7, 31);">Construction Success</span> </h1>
                                    <a href="#0" class="button-1 mt-15">Learn More <span class="ti-arrow-right"></span></a>
                                </div>
                            </div> 
                        </div>
                    </div>
                 </div>
                 <div class="text-left item bg-img" data-overlay-dark="4" data-background="<?php echo get_template_directory_uri(); ?>/img/architect.webp">
                     <div class="v-middle caption">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <h6 style="text-transform: uppercase;">welcome to cqm</h6>
                                    <h1>Your Trusted Partner in<br><span style="color: rgb(211, 7, 31);">Construction Success</span> </h1>
                                    <a href="#0" class="button-1 mt-15">Learn More <span class="ti-arrow-right"></span></a>
                                </div>
                            </div> 
                        </div>
                    </div>
                 </div>
        </div>
    </header> 
    <!-- divider line -->
    <div class="line-vr-section"></div>
    <!-- About -->
    <section id="section-about" data-scroll-index="1" class="about section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12 valign animate-box" data-animate-effect="fadeInLeft">
                    <div class="about-two-img full-width mb-30">
                        <div class="img1 img-grayscale">
                            <picture>
                              <source srcset="<?php echo get_template_directory_uri(); ?>/img/about.webp" type="image/webp">
                              <source srcset="<?php echo get_template_directory_uri(); ?>/img/about.jpg" type="image/jpeg">
                              <img src="<?php echo get_template_directory_uri(); ?>/img/about.webp" class="rounded-1" alt="">
                            </picture>
                        </div>
                        <div class="img2 img-grayscale"> 
                            <picture>
                            <source srcset="<?php echo get_template_directory_uri(); ?>/img/about2.webp" type="image/webp" >
                              <source srcset="<?php echo get_template_directory_uri(); ?>/img/about2.jpg" type="image/jpeg">
                              <img src="<?php echo get_template_directory_uri(); ?>/img/about2.webp" class="rounded-1" alt="">
                            </picture>
                            <div class="play-button">
                                <a  class="btn vid">
                                    <svg width="100px" height="100px" viewBox="0 0 100 100" preserveAspectRatio="none">
                                        <circle class="circle" cx="50" cy="50" r="48" stroke="white" stroke-width="2" fill="none" />
                                    </svg> <i class="ti-control-play"></i> </a>
                            </div>
                        </div>
                        <div class="award-icon animate-box" data-animate-effect="fadeInUp">
                            <div class="star">
                            
                                <div class="img"> <img src="<?php echo get_template_directory_uri(); ?>/img/star.png" alt=""> <span class="icon carex-certificate"></span> </div>
                            </div>
                            <h6>100%</h6>
                            <p>Quality Service</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 offset-lg-1 col-md-12 animate-box" data-animate-effect="fadeInRight">
                    <div class="section-title2 section-headline">About Us</div>
                    <div class="section-title">Precision.<span>Collaboration.</span> Achievement</div>
                    <p class="mb-30">Our construction management company is dedicated to becoming an industry leader by
                        optimizing time and financial resources, ensuring high efficiency. Through collaborative
                        teamwork, our skilled professionals deliver the highest standards of quality. Our guiding
                        principle of teamwork ensures we remain your trusted advisor and reliable partner
                        in achieving success.</p>
                    <ul class="list-unstyled list mb-30">
                        <li>
                            <div class="list-icon"> <span class="ti-check"></span> </div>
                            <div class="list-text">
                                <p>No Single Detail Without Attention</p>
                            </div>
                        </li>
                        <li>
                            <div class="list-icon"> <span class="ti-check"></span> </div>
                            <div class="list-text">
                                <p>Longevity and Fairness</p>
                            </div>
                        </li>
                        <li>
                            <div class="list-icon"> <span class="ti-check"></span> </div>
                            <div class="list-text">
                                <p>Supportive Service</p>
                            </div>
                        </li>
                    </ul> 
                    <a class="button-3">Learn More <span class="ti-arrow-right"></span></a>
                </div>
            </div>
        </div>
    </section>
    <!-- divider line -->
    <div class="line-vr-section"></div>
    <!-- Services -->                  
    <!-- divider line -->
    <div class="line-vr-section"></div>
    <!-- Process -->
    <section id="section-services" data-scroll-index="2" class="process section-padding bg-white">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12 text-center mb-30">
                <div class="section-title3 black section-headline">How We Work</div>
                <div class="section-title black">Our Services</div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-3 col-md-6 animate-box" data-animate-effect="fadeInUp">
                <div class="item active">
                    <!-- <span class="icon carex-car-checklist"></span> -->
                    <img class="services-icon" src="<?php echo get_template_directory_uri(); ?>/img/services/CQM-WHITE-ICON.svg" alt="">
                    <!-- <img class="services-icon" src="<?php echo get_template_directory_uri(); ?>/img/services/CQM-RED-ICON.svg" alt=""> -->
                    <h5>Value Engineering and Budgeting</h5>
                    <p>Planning, monitoring, and control of project’s monetary costs. Project Risk Management</p>
                    <div class="numb">01</div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 animate-box" data-animate-effect="fadeInUp">
                <div class="item">
                    <svg class="services-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1079.89 1057.52">
                        <path class="cls-1" d="M987.47,0H92.42L0,92.43v872.67l92.42,92.43h895.04l92.43-92.43V92.43L987.47,0ZM892.03,598.49l-282.32,282.32h-130.75l-291.11-291.11v-130.67L470.26,176.63h130.66l291.11,291.11v130.75Z"/>
                        <rect class="cls-1" x="430.29" y="419.04" width="219.37" height="219.37"/>
                    </svg>
                    <h5>Project Risk Management</h5>
                    <p>Management of various risks associated with construction projects such as financial, environmental, socio-economic and construction related risks.</p>
                    <div class="numb">02</div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 animate-box" data-animate-effect="fadeInUp">
                <div class="item">
                    <svg class="services-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1079.89 1057.52">
                        <path class="cls-1" d="M987.47,0H92.42L0,92.43v872.67l92.42,92.43h895.04l92.43-92.43V92.43L987.47,0ZM892.03,598.49l-282.32,282.32h-130.75l-291.11-291.11v-130.67L470.26,176.63h130.66l291.11,291.11v130.75Z"/>
                        <rect class="cls-1" x="430.29" y="419.04" width="219.37" height="219.37"/>
                    </svg>
                    <h5>Construction Management and Planning</h5>
                    <p>Project planning and coordination, control and monitoring of the construction process</p>
                    <div class="numb">03</div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 animate-box" data-animate-effect="fadeInUp">
                <div class="item">
                    <svg class="services-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1079.89 1057.52">
                        <path class="cls-1" d="M987.47,0H92.42L0,92.43v872.67l92.42,92.43h895.04l92.43-92.43V92.43L987.47,0ZM892.03,598.49l-282.32,282.32h-130.75l-291.11-291.11v-130.67L470.26,176.63h130.66l291.11,291.11v130.75Z"/>
                        <rect class="cls-1" x="430.29" y="419.04" width="219.37" height="219.37"/>
                    </svg>
                    <h5>Tendering</h5>
                    <p>Preparation of tender documentation in accordance to project characteristics and requirements; Bidding process management and bid analysis in order to correctly identify the winner</p>
                    <div class="numb">04</div>
                </div>
            </div>
            <div class="row justify-content-center services-wrapper">
            <div class="row">
                <div class="col-lg-3 col-md-6 animate-box" data-animate-effect="fadeInUp">
                    <div class="item">
                        <svg class="services-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1079.89 1057.52">
                            <path class="cls-1" d="M987.47,0H92.42L0,92.43v872.67l92.42,92.43h895.04l92.43-92.43V92.43L987.47,0ZM892.03,598.49l-282.32,282.32h-130.75l-291.11-291.11v-130.67L470.26,176.63h130.66l291.11,291.11v130.75Z"/>
                            <rect class="cls-1" x="430.29" y="419.04" width="219.37" height="219.37"/>
                        </svg>
                        <h5>Design Review</h5>
                        <p>A thorough evaluation of project design and technical documentations in order to determine whether or not these documents meet the project requirements</p>
                        <div class="numb">05</div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 animate-box" data-animate-effect="fadeInUp">
                    <div class="item">
                        <svg class="services-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1079.89 1057.52">
                            <path class="cls-1" d="M987.47,0H92.42L0,92.43v872.67l92.42,92.43h895.04l92.43-92.43V92.43L987.47,0ZM892.03,598.49l-282.32,282.32h-130.75l-291.11-291.11v-130.67L470.26,176.63h130.66l291.11,291.11v130.75Z"/>
                            <rect class="cls-1" x="430.29" y="419.04" width="219.37" height="219.37"/>
                        </svg>
                        <h5>Contract Management</h5>
                        <p>Contract creation, execution, and analysis to maximize operational and financial performance</p>
                        <div class="numb">06</div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 animate-box" data-animate-effect="fadeInUp">
                    <div class="item">
                        <svg class="services-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1079.89 1057.52">
                            <path class="cls-1" d="M987.47,0H92.42L0,92.43v872.67l92.42,92.43h895.04l92.43-92.43V92.43L987.47,0ZM892.03,598.49l-282.32,282.32h-130.75l-291.11-291.11v-130.67L470.26,176.63h130.66l291.11,291.11v130.75Z"/>
                            <rect class="cls-1" x="430.29" y="419.04" width="219.37" height="219.37"/>
                        </svg>
                        <h5>Feasibility</h5>
                        <p>Analysis of all the factors that have a potential impact on the project and all the resources needed for the project implementation, in order to determine the project potential and value to be attained.</p>
                        <div class="numb">07</div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 animate-box" data-animate-effect="fadeInUp">
                    <div class="item">
                        <svg class="services-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1079.89 1057.52">
                            <path class="cls-1" d="M987.47,0H92.42L0,92.43v872.67l92.42,92.43h895.04l92.43-92.43V92.43L987.47,0ZM892.03,598.49l-282.32,282.32h-130.75l-291.11-291.11v-130.67L470.26,176.63h130.66l291.11,291.11v130.75Z"/>
                            <rect class="cls-1" x="430.29" y="419.04" width="219.37" height="219.37"/>
                        </svg>
                        <h5>Real Estate Development</h5>
                        <p>Coordinating the process of property development from start to finish by putting together and managing a team of expert engineers, architects, lawyers and financiers</p>
                        <div class="numb">08</div>
                    </div>
                </div>
              </div>
            </div>
            <div class="col-lg-12 col-md-12 text-center services-wrapper-button">
                <button class="button-2 mt-15">See More</button>
            </div>
        </div>
    </div>
</section>
    <!-- divider line -->
    <div class="line-vr-section"></div>
    <!-- Services -->
    <section id="section-projects" class="services1 section-padding" data-scroll-index="3">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center mb-30">
                <div class="section-title3 section-headline">What We Do</div>
                <div class="section-title">Our Projects</div>
            </div>
        </div>
    </div>
    <!-- Our Projects Slider -->
    <div class="full-width">
    <div class="row">
        <div class="col-md-12 text-center  test">
            <div class="white-vr-section"></div>
            <?php
            // Get terms for the project_category taxonomy
            $terms = get_terms(array(
                'taxonomy' => 'project_category',
                'hide_empty' => false,
            ));

            if (!is_wp_error($terms) && !empty($terms)) {
                foreach ($terms as $term) {
                    echo '<a class="categories" href="#" data-category="' . esc_attr($term->slug) . '">' . esc_html($term->name) . '</a> ';
                }
            }
            ?>
            <div class="owl-carousel owl-theme" id="project-slider">
                <?php
                $args = array(
                    'post_type' => 'project',
                    'posts_per_page' => -1
                );
                $projects = new WP_Query($args);
                ?>
                <?php
                $projects_data = array();
                foreach ($projects->posts as $project) {
                    $project_categories = get_the_terms($project->ID, 'project_category');
                    $categories = array();
                    if ($project_categories && !is_wp_error($project_categories)) {
                        foreach ($project_categories as $category) {
                            $categories[] = array(
                                'id' => $category->term_id,
                                'name' => $category->name,
                                'slug' => $category->slug
                            );
                        }
                    }
                    $project_url = get_permalink($project->ID);
                    $featured_image = wp_get_attachment_image_src(get_post_thumbnail_id($project->ID), 'full');
                    $image_url = $featured_image ? $featured_image[0] : null;
                    $projects_data[] = array(
                        'id' => $project->ID,
                        'title' => $project->post_title,
                        'content' => $project->post_content,
                        'categories' => $categories,
                        'featured_image' => $image_url,
                        'url' => $project_url
                    );
                }
                ?>
            </div>
        </div>
    </div>
</div>
<div class="col-lg-12 col-md-12 text-center">
    <a class="button-1 mt-15" href="<?php echo esc_url(get_post_type_archive_link('project')); ?>">Learn More <span class="ti-arrow-right"></span></a>
</div>
<script>
    var projectsData = <?php echo json_encode($projects_data); ?>;
    var owlInstance = null; // Variable to hold the Owl Carousel instance

    document.addEventListener('DOMContentLoaded', function() {
        initializeSlider(projectsData);

        // Category filter click handler
        document.querySelectorAll('.categories').forEach(function(categoryLink) {
            categoryLink.addEventListener('click', function(event) {
                event.preventDefault();

                // Remove the active class from all category links
                document.querySelectorAll('.categories').forEach(function(link) {
                    link.classList.remove('active');
                });

                // Add the active class to the clicked category link
                event.target.classList.add('active');

                var selectedCategory = event.target.getAttribute('data-category');
                filterProjectsByCategory(selectedCategory);
            });
        });
    });

    function initializeSlider(projects) {
        var slider = $('#project-slider');

        // Initialize Owl Carousel or reinitialize if it exists
        if (owlInstance !== null) {
            owlInstance.trigger('destroy.owl.carousel').removeClass('owl-loaded');
        }
        slider.html(''); // Clear existing items

        projects.forEach(function(project) {
            var item = $('<div>').addClass('item');
            item.html(`
                <a href="${project.url}">
                    <div class="wrap">
                        <div class="wrapper-img">
                            <picture>
                                <img src="${project.featured_image}" class="img-fluid rounded-1" alt="${project.title}">
                            </picture>
                        </div>
                        <div class="wrapper-title">
                            <h6>${project.title}</h6>
                        </div>
                    </div>
                </a>
            `);
            slider.append(item);
        });

        // Reinitialize Owl Carousel after populating
        owlInstance = slider.owlCarousel({
          loop: true,
        margin: 10,
        nav: false,
        dots: false,
        items: 3, // Default items to show
        responsive: {
            0: {
                items: 1 // 1 item for screens 0px and up
            },
            600: {
                items: 2 // 2 items for screens 600px and up
            },
            1000: {
                items: 3 // 3 items for screens 1000px and up
            }
        }
        });
    }

    function filterProjectsByCategory(categorySlug) {
        var filteredProjects = projectsData.filter(function(project) {
            return project.categories.some(function(category) {
                return category.slug === categorySlug;
            });
        });

        // Initialize or reinitialize slider with filtered projects
        initializeSlider(filteredProjects);
    }
</script>

</section>
    <div class="line-vr-section"></div>
    <!-- აქედან არის ჩემი -->
    <section class="section-padding">
      <div class="container">
        <div class="row">
          <div class="col-md-12 text-center mb-30">
            <div class="section-title3 section-headline">Testimonials</div>
            <div class="section-title" >What <span>Customers</span> Say</div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="testimonials left">
              <figure class="img-grayscale">
                <picture>
                  <source srcset="<?php echo get_template_directory_uri(); ?>/img/businessman-businesswoman.webp" type="image/webp">
                  <source srcset="<?php echo get_template_directory_uri(); ?>/img/businessman-businesswoman.jpeg" type="image/jpeg">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/businessman-businesswoman.webp"  class="img-fluid rounded-1" alt="businessman-businesswoman">
                </picture>
              </figure>
              <div class="caption testimonials">
                <div class="owl-carousel owl-theme">
                  <div class="item-box">
                    <span class="quote"><i class="fa fa-quote-left"></i></span>
                    <h5>ABOUT CQM</h5>
                    <p>
                      "CQM's expertise in construction quality management is
                      unparalleled. Their meticulous oversight and thorough
                      inspections give us confidence that our projects are built
                      to last. The integration of their minimalistic red bird
                      logo with the third-eye symbol truly represents their
                      vision and vigilance in the industry."
                    </p>
                    <div class="info">
                      <div class="author-img">
                        <img src="<?php echo get_template_directory_uri(); ?>/img/team/ninogelovani.png" alt="customer img">
                      </div>
                      <div class="cont">
                        <h6>Nino Gelovani</h6>
                        <span>Customer</span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Video -->
    <section
      class="video-wrapper video section-padding bg-img bg-fixed"
      data-overlay-dark="5"
      data-background="<?php echo get_template_directory_uri(); ?>/img/construction-worker.webp">
      <div class="container">
        <div class="row">
          <div class="col-md-12 text-center">
            <div class="section-title3 white section-headline">Explore</div>
            <div class="section-title white">Our Promo <br/>Video</div>
          </div>
        </div>
        <div class="row">
          <div class="text-center col-md-12">
            <a class="vid" >
              <div class="vid-butn">
                <span class="icon"> <i class="ti-control-play"></i> </span>
              </div>
            </a>
          </div>
        </div>
      </div>
    </section>
    <!-- Team -->
    <section
      id="team"
      class="team bg-white"
    >
      <div class="container ">
        <div class="row">
          <div class="col-md-12 text-center mb-30">
            <div class="section-title3 black section-headline">Certified Team</div>
            <div class="section-title black" >Our Experts <br/>Team</div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="owl-carousel owl-theme">
              <div class="item">
                <div class="team-img">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/team/giorgimurjikneli.jpeg" alt="expert team member" class="w-100">
                </div>
                <div class="con">
                  <h5 class="mb-0">
                    <a 
                      >Giorgi Murjikneli<br /><span
                        >Head Of Business Development</span
                      ></a
                    >
                  </h5>
                  <div class="arrow">
                    <a 
                      ><span class="ti-arrow-top-right"></span
                    ></a>
                  </div>
                </div>
              </div>
              <div class="item">
                <div class="team-img">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/team/natiatchumburidze.png" alt="expert team member" class="w-100">
                </div>
                <div class="con">
                  <h5 class="mb-0">
                    <a 
                      >Natia Tchumburidze<br /><span>CEO</span></a
                    >
                  </h5>
                  <div class="arrow">
                    <a 
                      ><span class="ti-arrow-top-right"></span
                    ></a>
                  </div>
                </div>
              </div>
              <div class="item">
                <div class="team-img">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/team/giorgistepnadze.png" alt="expert team member" class="w-100">
                </div>
                <div class="con">
                  <h5 class="mb-0">
                    <a 
                      >Giorgi Stepnadze<br /><span>Technical Direcctor</span></a
                    >
                  </h5>
                  <div class="arrow">
                    <a 
                      ><span class="ti-arrow-top-right"></span
                    ></a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- divider line -->
    <div class="line-vr-section"></div>
    <!-- Clients -->
    <section id="section-clients" class="clients section-padding" data-scroll-index="4">
      <div class="container">
        <div class="row">
        <div class="col-md-12 text-center">
            <div class="section-title3 black3 section-headline" style="color:rgb(6,23,44)">Trusted By</div>
            <div class="client-title black" >Our Clients and Partners</div>
        </div>
          <div class="col-md-12">
            <div class="owl-carousel owl-theme">
              <div class="clients-logo">
                  <a href="#0"><img src="<?php echo get_template_directory_uri(); ?>/img/clients/1.png" alt="" /></a>
              </div>
              <div class="clients-logo">
                  <a href="#0"><img src="<?php echo get_template_directory_uri(); ?>/img/clients/2.png" alt="" /></a>
              </div>
              <div class="clients-logo">
                  <a href="#0"><img src="<?php echo get_template_directory_uri(); ?>/img/clients/3.png" alt="" /></a>
              </div>
              <div class="clients-logo">
                  <a href="#0"><img src="<?php echo get_template_directory_uri(); ?>/img/clients/4.png" alt="" /></a>
              </div>
              <div class="clients-logo">
                  <a href="#0"><img src="<?php echo get_template_directory_uri(); ?>/img/clients/5.png" alt="" /></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
 <?php get_footer(); ?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const toggleButton = document.querySelector('.services-wrapper-button .button-2');
        const servicesWrapper = document.querySelector('.services-wrapper');

        toggleButton.addEventListener('click', function() {
            if (servicesWrapper.style.display === 'none' || servicesWrapper.style.display === '') {
                servicesWrapper.style.display = 'block';
                toggleButton.textContent = 'See Less';
            } else {
                servicesWrapper.style.display = 'none';
                toggleButton.textContent = 'Learn More';
            }
        });
    });
</script>